/* $Header: ReadTIN.java 05-dec-2007.17:14:40 rkothuri Exp $ */

/* Copyright (c) 2006, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION
     Read the Points LOB and the triangle LOB associated with a TIN Block.
       The Points LOB has n points each of the form:
        < d 8-byte doubles represeting the d numbers for d dimensions>,
        < 2 4-byte integers for representing the point using ptn_id, pt_id >
       The triangles LOB has n triangles specified as :
        < 6 integers, 2 each representing each of the 3 vertices of a triangle.
          Each vertex is specified by a point <ptn_id, pt_id>.

   PRIVATE CLASSES
     ReadTIN

   NOTES

   MODIFIED    (MM/DD/YY)
    rkothuri     12/05/07 - fix 6468782
    rkothuri     10/30/06 - Creation
 */

/**
 *  @version $Header: ReadTIN.java 05-dec-2007.17:14:40 rkothuri Exp $
 *  @author  rkothuri 
 *   @since   release specific (what release of product did this appear in)
 * 
 */

import oracle.spatial.util.*;
//import oracle.spatial.util.GML;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.*;
import java.io.*;
import java.util.*;
import oracle.jdbc.*;
import java.sql.*;

import oracle.sql.BLOB;
import oracle.sql.CLOB;

import oracle.sql.STRUCT;


public class ReadTIN 
{

    private static String host = "stadb28.us.oracle.com";
    private static String port = "1521";
    private static String sid = "sdo_11";
    private static String driver = "thin";
    private static String user = "scott";
    private static String password = "tiger";
    private static String fTable = "base";
    private static String fCol = "pc";
    private static String blkTable = "blktab";
    private static String blkCol = "pc";
    private static  Connection connection = null;

    
    /*************************************************************************/
    static private String usage()
    {
      return "Usage: java ReadTIN \n" +
             "-host hostName \n-port portNumber\n" +
             "-sid SID \n-driver jdbcDriver[thin:oci]\n" +
             "-user userName\n" +
             "-password password\n" ;
    }

    /*************************************************************************/
    public static void setConnection(){
      String connectString =
                "jdbc:oracle:" + driver + ":@"
                + "(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(HOST="
                +  host + ")"
                + "(PROTOCOL=tcp)(PORT="
                + port + ")))"
                + "(CONNECT_DATA=(SID="
                + sid + ")))";
                                                                                 
      try {
        DriverManager.registerDriver(new OracleDriver());
        connection = DriverManager.getConnection(
                       connectString, user, password);
                                                                                 
      }
      catch (Throwable t)
      {
        System.out.println(
                        t.toString() + ": \n" + t.getMessage() +
                        "Error attempting to connect to database");
       }

     }
    /*************************************************************************/
    public static Connection getConnection() { return connection; }

    /*************************************************************************/
    private static void processCmdLineArgs(String[] args)
    {
                                                                                 
        // process db connection information
      
          if ( args.length > 0  )
         {
            for ( int i = 0 ; i < args.length ;i++ )
            {
              if ( args[i].equalsIgnoreCase("-host") )
                host = args[++i];
              else if ( args[i].equalsIgnoreCase("-port") )
                port = args[++i];
              else if ( args[i].equalsIgnoreCase("-sid") )
                sid = args[++i];
              else if ( args[i].equalsIgnoreCase("-driver") )
                driver = args[++i];
              else if ( args[i].equalsIgnoreCase("-user") )
                user = args[++i];
              else if ( args[i].equalsIgnoreCase("-password") )
                password = args[++i];
              else if ( args[i].equalsIgnoreCase("-h") )
              {
                 System.out.println(usage());
                 System.exit(0);
              }
           }
         }
	 else {
                System.out.println("Using default parameters");
         }
         setConnection();
      
    }
    /*************************************************************************/


  public static void main(String args[])
    throws IOException
  {    
   
    processCmdLineArgs(args);

        // assume # of dimensions to be 3
        int ndim = 3;
    
        double[] ords = new double[ndim];
        
        // get #poitns, points lob from blktab
        String sqlStr = "SELECT num_points, points, num_triangles," +
                        " triangles FROM blktab";
        Connection conn = getConnection();
        Statement stmt = null;
        ResultSet rset = null;
        DataInputStream ptdis = null;
        DataInputStream trdis = null;
        try
        {

          stmt = conn.createStatement ();
          rset = stmt.executeQuery (sqlStr);

          while (rset.next ())
          {
            int num_points  = rset. getInt(1);
            System.out.println("Numpoints = " + num_points);
            Blob ptlob = rset.getBlob(2);
            int num_triangles = rset.getInt(3);
            Blob trlob = rset.getBlob(4);

            ptdis = new DataInputStream(ptlob.getBinaryStream());

            /* Read Point LOB */
            for (int i=0 ; i< num_points; i++) {
             // first 8*ndim bytes are ndim doubles
             for (int j=0; j<ndim; j++) {
                ords[j] = ptdis.readDouble();
             }
             // read the ptn_id
             int ptn_id = ptdis.readInt();
             
             // read the pt_id
             int pt_id = ptdis.readInt();
             
             System.out.println("<"+ptn_id+","+pt_id + ">"+ ords[0] + ","+ ords[1]);
            }

            trdis = new DataInputStream(trlob.getBinaryStream());

            /* Read Point LOB */
            for (int i=0 ; i< num_triangles; i++) {
	       System.out.println("Triangle " +  i ); 

	     // each triangle vertex is specified <as ptn_id, pt_id>
             for (int j=0; j<3; j++) {
	       System.out.println("vertex " +  j + " : < " + 
		trdis.readInt()+ ", " + trdis.readInt());
             }
            }


            
          }
        } catch (SQLException e)
        {
          System.out.println("Error: " + e.getMessage());
        }
        finally { 
          try {
            if (rset != null)    {rset.close(); rset = null;}
            if (stmt !=null)     {stmt.close(); stmt = null;}
            if (ptdis!=null)       {ptdis.close(); ptdis = null;}
            if (trdis!=null)       {trdis.close(); trdis = null;}
          }
          catch (SQLException ex) {}
        }
  }
}


